// 加载FTB Teams API

PlayerEvents.chat(e => {
    let p = e.player;
    let 玩家UUID = p.uuid;
    let 聊天内容 = e.message.trim();
    let 已处理队内聊天 = false; 

    if (聊天内容.startsWith('!') || 聊天内容.startsWith('！')) {
        已处理队内聊天 = true; 

        let 实际聊天消息 = 聊天内容.substring(1).trim();

        if (实际聊天消息.length === 0) {
            p.tell(Text.of('FTB队内消息不能为空！').red());
        } else {
            let ftbApi = $FTB团队.INSTANCE;
            let manager = ftbApi.getManager();
            let optionalTeam = manager.getTeamForPlayerID(玩家UUID);

            if (optionalTeam && optionalTeam.isPresent()) {
                let 玩家所在FTB队伍 = optionalTeam.get();
                let 成员列表 = 玩家所在FTB队伍.getMembers();
                let 成员数量 = 成员列表 ? 成员列表.size() : 0;

                if (成员数量 > 2) {
                    玩家所在FTB队伍.sendMessage(玩家UUID, 实际聊天消息);
                } else {
                    p.tell(Text.of('你所在的队伍内没有其他成员，无法发送队内消息。').yellow());
                }
            } else {
                p.tell(Text.of('你当前未加入任何FTB队伍，无法发送队内消息。').color('red'));
            }
        }
    }
    if (已处理队内聊天) {
        e.cancel();
    }
});